<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Menu;
use App\Core\Telegram;
use App\Services\AuthService;

final class MainController
{
    public function __construct(private Telegram $tg, private AuthService $auth) {}

    public function start(int $chatId, int $userId): void
    {
        $isAdmin = $this->auth->isAdmin($userId);
        $this->tg->sendMessage($chatId, "مرحباً 👋\n\nاختر من القائمة:", Menu::mainKeyboard($isAdmin));
    }

    public function help(int $chatId, int $userId): void
    {
        $isAdmin = $this->auth->isAdmin($userId);
        $this->tg->sendMessage($chatId, "أرسل /start لإظهار القائمة.", Menu::mainKeyboard($isAdmin));
    }

    public function account(int $chatId, int $userId): void
    {
        $u = $this->auth->getUser($userId);
        if (!$u) { $this->tg->sendMessage($chatId, "لا يوجد حساب."); return; }
        $text = "ℹ️ <b>حسابي</b>\n\n"
              . "• الاسم: " . ($u['first_name'] ?? '-') . " " . ($u['last_name'] ?? '') . "\n"
              . "• اليوزر: @" . ($u['username'] ?? '-') . "\n"
              . "• user_id: {$u['user_id']}\n"
              . "• chat_id: {$u['chat_id']}\n"
              . "• الدور: {$u['role']}\n";
        $this->tg->sendMessage($chatId, $text);
    }
}
