<?php
declare(strict_types=1);

spl_autoload_register(function (string $class): void {
    $prefix = 'App\\';
    $baseDir = __DIR__ . '/../';
    if (strncmp($prefix, $class, strlen($prefix)) !== 0) return;

    $rel = substr($class, strlen($prefix));
    $file = $baseDir . str_replace('\\', '/', $rel) . '.php';
    if (is_file($file)) require_once $file;
});
