<?php
declare(strict_types=1);

namespace App\Core;

final class Helpers
{
    public static function now(): string
    {
        $tz = Config::BOT_TIMEZONE ?: 'UTC';
        $dt = new \DateTime('now', new \DateTimeZone($tz));
        return $dt->format('Y-m-d H:i:s');
    }

    public static function cleanText(string $t): string
    {
        $t = trim($t);
        $t = preg_replace('/\s+/u', ' ', $t) ?? $t;
        return $t;
    }

    public static function randToken(int $len = 18): string
    {
        return rtrim(strtr(base64_encode(random_bytes($len)), '+/', '-_'), '=');
    }

    public static function esc(string $t): string
    {
        return htmlspecialchars($t, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }

    public static function statusLabel(string $status): string
    {
        return match ($status) {
            'NEW' => '🆕 جديد',
            'SEEN' => '👀 تمت الرؤية',
            'IN_PROGRESS' => '⚙️ جاري الإنجاز',
            'DONE' => '✅ مكتملة',
            default => $status,
        };
    }

    public static function nextStatus(string $status): string
    {
        return match ($status) {
            'NEW' => 'SEEN',
            'SEEN' => 'IN_PROGRESS',
            'IN_PROGRESS' => 'DONE',
            'DONE' => 'NEW',
            default => 'NEW',
        };
    }
}
