<?php
declare(strict_types=1);

namespace App\Core;

final class Logger
{
    public static function error(string $msg, array $ctx = []): void
    {
        if (!Config::LOG_ERRORS) return;
        $line = '[' . date('Y-m-d H:i:s') . '] [ERROR] ' . $msg . ' | ' . json_encode($ctx, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        $path = Config::LOG_PATH;
        @mkdir(dirname($path), 0775, true);
        @file_put_contents($path, $line . PHP_EOL, FILE_APPEND);
    }
}
