<?php
declare(strict_types=1);

namespace App\Core;

final class Menu
{
    public static function mainKeyboard(bool $isAdmin): array
    {
        $rows = [
            ['✅ مهامي', '➕ إضافة مهمة'],
            ['👥 فرقي', 'ℹ️ حسابي'],
        ];
        if ($isAdmin) $rows[] = ['👑 لوحة الأدمن'];
        return [
            'reply_markup' => json_encode([
                'keyboard' => array_map(fn($r)=> array_map(fn($b)=>['text'=>$b], $r), $rows),
                'resize_keyboard' => true,
            ], JSON_UNESCAPED_UNICODE)
        ];
    }
}
