<?php
declare(strict_types=1);

namespace App\Repositories;

use App\Core\DB;
use App\Core\Helpers;

final class ForcedChannelRepo
{
    public function listActive(): array
    {
        return DB::pdo()->query("SELECT * FROM forced_channels WHERE is_active=1 ORDER BY id ASC")->fetchAll();
    }

    public function add(string $username, string $invite): void
    {
        $sql = "INSERT INTO forced_channels (channel_username, invite_url, is_active, created_at)
                VALUES (:u,:i,1,:t)
                ON DUPLICATE KEY UPDATE invite_url=VALUES(invite_url), is_active=1";
        DB::pdo()->prepare($sql)->execute([':u'=>$username, ':i'=>$invite, ':t'=>Helpers::now()]);
    }

    public function deactivate(int $id): void
    {
        DB::pdo()->prepare("UPDATE forced_channels SET is_active=0 WHERE id=:id")->execute([':id'=>$id]);
    }

    public function countActive(): int
    {
        return (int)DB::pdo()->query("SELECT COUNT(*) c FROM forced_channels WHERE is_active=1")->fetch()['c'];
    }
}
