<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$root = dirname(__DIR__);

if (!is_file($root . '/app/Core/Config.php')) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Missing app/Core/Config.php (copy Config.php.sample -> Config.php)'], JSON_UNESCAPED_UNICODE);
    exit;
}
require_once $root . '/app/Core/Config.php';
require_once $root . '/app/Core/Autoload.php';

use App\Core\Router;
use App\Core\Logger;

$raw = file_get_contents('php://input') ?: '';
if ($raw === '') { echo json_encode(['ok'=>true]); exit; }

try {
    $update = json_decode($raw, true);
    if (!is_array($update)) { echo json_encode(['ok'=>true]); exit; }

    (new Router())->handle($update);

    echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
    Logger::error('Webhook exception', ['err'=>$e->getMessage(), 'file'=>$e->getFile(), 'line'=>$e->getLine()]);
    echo json_encode(['ok'=>true]);
}
